#rem Clear Box Outlet.bas This is the receiver in a clear box with attached blue outlet box.
This box contains a duplex receptacle, a transformer and a relay, 7A capacity
One receptacle labelled "LIVE" is not switched; It is connected o a power transformer.
The other receptacle labelled "SWITCHED" is controlled by a wire from the Clear Receiver;
The Clear Receiver box also has two outputs configured for 5V relays connected to an audio socket.
It has a 434 MHz receiver which receives 2400 Hz messages. 
The applicable messages start with an unlock code "14L1776", then a key code character.
hey originate from manual transitters.
This program accepts messages with the following key codes:
m(on),J(off)	These control the Outlet. 
d(on),9(off)	These control the ring of the socket.
X(on),N(off)	These control the tip of the socket.
John Saunders 10/12/2020
#endrem

#picaxe 08M2

'Output Ports
symbol Ring_Port      = C.0		
symbol Outlet_Port    = C.1		
symbol Tip_Port       = C.2		

'Input ports
symbol Rcvr_In          = C.4		'Data from messages

'Variables:

'Interrupt variables:
symbol Rcvr_Val     = b1
symbol temp         = b2

'Constants:
symbol Threshold  	= "3"			'Below this its night, above its day
symbol Alarm_On_Delay	= 25		'Delay to turn on the ceiling light in 200 ms
symbol Alarm_Off_Delay	= 75		'Delay to turn offthe ceiling light in 200 ms


init:
SETFREQ m8
HIGH Tip_Port			'Off
LOW Outlet_Port
HIGH Ring_Port
SETINT  %00001000,%00001000	'Interrupt when C,3 high

main:
PAUSE 400
GOTO main

Interrupt:
LET Temp = 0
LET Rcvr_Val = "~"
DO WHILE PinC.3 = 1	AND Temp < 20		'Noise interrupts are nearly always shorter
	LET Temp = Temp + 1	'Twice as fast as INC Usual count is 15
LOOP
IF Temp < 10 THEN End_Interrupt	'Minimises the time to recover from a noise interrupt
SERIN [40],Rcvr_In,N2400_8,("14L1776"),Rcvr_Val
IF Rcvr_Val = "~" THEN End_Interrupt
IF Rcvr_Val = "O" THEN End_Interrupt
SELECT Rcvr_Val
	CASE "m" 
		HIGH Outlet_Port
	CASE "J"
		LOW Outlet_Port
	CASE "d" 
		LOW Ring_Port
	CASE "9"
		HIGH Ring_Port
	CASE "X" 
		LOW Tip_Port
	CASE "N"
		HIGH Tip_Port
ENDSELECT
DO
	PAUSE 1
LOOP WHILE PinC.3 = 1
End_Interrupt:
SETINT  %00001000,%00001000	'Interrupt when C.3 high
RETURN